/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.memory;

import emulator.EmulatorException;
import emulator.hardware.memory.MemoryBlock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoryBlockTest {
    private static int memory_block_size = 4096;
    private MemoryBlock memory;

    @Before
    public void setUp() throws Exception {
        this.memory = new MemoryBlock(memory_block_size);
    }

    @Test
    public void testInitialAllZero() throws EmulatorException {
        int i = 0;
        while (i < memory_block_size) {
            Assert.assertEquals((long)0L, (long)this.memory.read(i));
            ++i;
        }
    }

    @Test
    public void testReadWrite() throws EmulatorException {
        this.memory.write(0, 85);
        this.memory.write(1, 170);
        this.memory.write(memory_block_size - 1, 255);
        Assert.assertEquals((long)85L, (long)this.memory.read(0));
        Assert.assertEquals((long)170L, (long)this.memory.read(1));
        Assert.assertEquals((long)0L, (long)this.memory.read(2));
        Assert.assertEquals((long)0L, (long)this.memory.read(memory_block_size - 2));
        Assert.assertEquals((long)255L, (long)this.memory.read(memory_block_size - 1));
    }
}

